<?php
require_once 'config.php';

try {
    // Check parents for student ID 1 (Elisha Awonseba Ayakpagi)
    $stmt = $pdo->prepare("SELECT * FROM parents WHERE student_id = ?");
    $stmt->execute([1]);
    $parents = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "Parent records for student ID 1 (Elisha Awonseba Ayakpagi):\n";
    if (empty($parents)) {
        echo "No parent records found.\n";
    } else {
        foreach ($parents as $parent) {
            echo "- ID: {$parent['id']}, Name: {$parent['full_name']}, Phone: {$parent['mobile_phone']}, Relationship: {$parent['relationship']}\n";
        }
    }

    // Check the current query result
    $stmt = $pdo->prepare("SELECT s.id, s.first_name, s.last_name, u.username, p.full_name as parent_name, p.mobile_phone as parent_phone FROM students s JOIN student_users u ON s.user_id = u.id LEFT JOIN parents p ON s.id = p.student_id WHERE s.first_name = ? AND s.last_name = ?");
    $stmt->execute(['Elisha', 'Ayakpagi']);
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "\nQuery results (should show duplicates if multiple parents):\n";
    foreach ($results as $result) {
        echo "- Student: {$result['first_name']} {$result['last_name']}, Parent: {$result['parent_name']}\n";
    }

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
