<?php
require_once 'config.php';

try {
    // Get all foreign key constraints referencing users table
    $stmt = $pdo->query("
        SELECT
            TABLE_NAME,
            COLUMN_NAME,
            CONSTRAINT_NAME,
            REFERENCED_TABLE_NAME,
            REFERENCED_COLUMN_NAME
        FROM
            INFORMATION_SCHEMA.KEY_COLUMN_USAGE
        WHERE
            REFERENCED_TABLE_SCHEMA = DATABASE() AND
            REFERENCED_TABLE_NAME = 'users'
    ");
    $foreign_keys = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "Foreign key constraints referencing 'users' table:\n";
    foreach ($foreign_keys as $fk) {
        echo "- {$fk['TABLE_NAME']}.{$fk['COLUMN_NAME']} -> {$fk['REFERENCED_TABLE_NAME']}.{$fk['REFERENCED_COLUMN_NAME']} (constraint: {$fk['CONSTRAINT_NAME']})\n";
    }

    if (empty($foreign_keys)) {
        echo "No foreign key constraints found.\n";
    }

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
