<?php
require_once '../config.php';

header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

$user_id = $_SESSION['user_id'];

try {
    // Get user's active subscription with package details
    $stmt = $pdo->prepare("
        SELECT cs.*, sp.name as package_name, sp.code as package_code,
               sp.description as package_description, sp.max_students,
               sp.max_teachers, sp.features, sp.price_ghs
        FROM client_subscriptions cs
        JOIN subscription_packages sp ON cs.package_id = sp.id
        WHERE cs.user_id = ? AND cs.subscription_status = 'active'
        LIMIT 1
    ");
    $stmt->execute([$user_id]);
    $subscription = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($subscription) {
        // Parse features JSON
        $subscription['features'] = json_decode($subscription['features'], true);

        // Check if subscription is expired
        $current_date = date('Y-m-d');
        if ($subscription['end_date'] < $current_date) {
            // Auto-expire subscription
            $update_stmt = $pdo->prepare("UPDATE client_subscriptions SET subscription_status = 'expired' WHERE id = ?");
            $update_stmt->execute([$subscription['id']]);
            $subscription['subscription_status'] = 'expired';
        }

        echo json_encode([
            'success' => true,
            'subscription' => $subscription
        ]);
    } else {
        echo json_encode([
            'success' => true,
            'subscription' => null,
            'message' => 'No active subscription found'
        ]);
    }

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => 'Database error: ' . $e->getMessage()
    ]);
}
?>
