<?php
require_once '../config.php';
require_once '../includes/notification_manager.php';

if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'accountant'])) {
    header('Location: ../login.php');
    exit();
}

$message = '';
$notification_manager = new NotificationManager($pdo);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = trim($_POST['title']);
    $message_content = trim($_POST['message']);
    $target_audience = $_POST['target_audience'];

    if (empty($title) || empty($message_content)) {
        $message = '<div class="alert alert-danger">Please fill in all required fields.</div>';
    } else {
        // Save announcement to database
        $stmt = $pdo->prepare("
            INSERT INTO announcements (title, message, target_audience, sent_by)
            VALUES (?, ?, ?, ?)
        ");
        $stmt->execute([$title, $message_content, $target_audience, $_SESSION['user_id']]);

        // Send notifications
        $announcement_data = [
            'title' => $title,
            'message' => $message_content,
            'target_audience' => $target_audience
        ];

        $notification_manager->sendAnnouncement($announcement_data);

        $message = '<div class="alert alert-success">Announcement sent successfully!</div>';
    }
}

include '../includes/admin_header.php';
?>

<style>
.form-group {
    margin-bottom: 20px;
    position: relative;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: #495057;
    position: relative;
    z-index: 2;
    background: white;
    padding: 0 5px;
}

.form-control {
    position: relative;
    z-index: 1;
    margin-top: 0;
    width: 100%;
}

select.form-control {
    padding: 10px 15px;
    border: 1px solid #ced4da;
    border-radius: 0.25rem;
    background-color: #fff;
    min-height: 38px;
    position: relative;
    z-index: 1;
    -webkit-appearance: menulist;
    -moz-appearance: menulist;
    appearance: menulist;
}

select.form-control:focus {
    border-color: #80bdff;
    outline: 0;
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
    z-index: 3;
}

/* Ensure proper spacing and visibility */
.form-group select {
    display: block;
    clear: both;
}
</style>

<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4><i class="fas fa-bullhorn"></i> Send Announcement</h4>
                </div>
                <div class="card-body">
                    <?php echo $message; ?>

                    <form method="POST" action="">
                        <div class="form-group">
                            <label for="title">Announcement Title *</label>
                            <input type="text" class="form-control" id="title" name="title" required>
                        </div>

                        <div class="form-group">
                            <label for="target_audience">Target Audience</label>
                            <select class="form-control" id="target_audience" name="target_audience">
                                <option value="all">All (Students, Parents, Teachers, Staff)</option>
                                <option value="students">Students Only</option>
                                <option value="parents">Parents Only</option>
                                <option value="teachers">Teachers Only</option>
                                <option value="staff">Staff Only</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="message">Message *</label>
                            <textarea class="form-control" id="message" name="message" rows="8" required
                                      placeholder="Enter your announcement message here..."></textarea>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-paper-plane"></i> Send Announcement
                            </button>
                            <a href="<?php echo $_SESSION['role'] === 'accountant' ? '../accounts/accounting_dashboard.php' : 'admin_dashboard.php'; ?>" class="btn btn-secondary ml-2">
                                <i class="fas fa-arrow-left"></i> Back to Dashboard
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Auto-resize textarea
document.getElementById('message').addEventListener('input', function() {
    this.style.height = 'auto';
    this.style.height = this.scrollHeight + 'px';
});
</script>

<?php include '../includes/admin_footer.php'; ?>
