<?php
require_once '../config.php';
require_once '../includes/access_control.php';

// Get class from GET parameter
$class = $_GET['class'] ?? '';
if (empty($class)) {
    die('Class parameter is required.');
}

// Fetch school settings
$school_settings = $pdo->query("SELECT school_name, address, phone, email, logo_path FROM school_settings LIMIT 1")->fetch(PDO::FETCH_ASSOC);

// Fetch students for the class
$query = "SELECT s.*, su.username FROM students s JOIN student_users su ON s.user_id = su.id WHERE s.class = ? ORDER BY s.last_name ASC, s.first_name ASC";
$stmt = $pdo->prepare($query);
$stmt->execute([$class]);
$students = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student List - <?php echo htmlspecialchars($class); ?></title>
    <style>
        @media print {
            body { margin: 0; font-family: Arial, sans-serif; }
            .no-print { display: none; }
            .page-break { page-break-before: always; }
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 20px;
            background: #f8f9fa;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            border-radius: 10px;
            overflow: hidden;
        }

        .header {
            background-color: white;
            color: #495057;
            padding: 30px;
            text-align: center;
            position: relative;
        }

        .school-name {
            font-size: 2.5em;
            margin: 0;
            font-weight: 700;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
        }

        .school-info {
            font-size: 1.1em;
            margin: 10px 0;
            opacity: 0.9;
        }

        .class-header {
            background: #f8f9fa;
            padding: 25px;
            text-align: center;
            border-bottom: 2px solid #dee2e6;
        }

        .class-title {
            font-size: 2em;
            color: #495057;
            margin: 0;
            font-weight: 600;
        }

        .student-count {
            color: #6c757d;
            margin-top: 5px;
        }

        .students-table {
            width: 100%;
            border-collapse: collapse;
        }

        .students-table th,
        .students-table td {
            padding: 15px;
            text-align: left;
            border-bottom: 1px solid #dee2e6;
        }

        .students-table th {
            background: #f8f9fa;
            font-weight: 600;
            color: #495057;
            font-size: 1.1em;
        }

        .students-table tr:nth-child(even) {
            background: #f8f9fa;
        }

        .students-table tr:hover {
            background: #e9ecef;
        }

        .student-photo {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid #dee2e6;
        }

        .no-photo {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: #e9ecef;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #6c757d;
            font-weight: bold;
        }

        .print-btn {
            position: fixed;
            top: 20px;
            right: 20px;
            background: #28a745;
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 16px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.2);
        }

        .print-btn:hover {
            background: #218838;
        }

        @media print {
            .print-btn { display: none; }
            .container { box-shadow: none; }
        }
    </style>
</head>
<body>
    <button class="print-btn no-print" onclick="window.print()">Print</button>

    <div class="container">
        <div class="header">
            <?php if (!empty($school_settings['logo_path'])): ?>
                <img src="../<?php echo htmlspecialchars($school_settings['logo_path']); ?>" alt="School Logo" class="school-logo">
            <?php else: ?>
                <h1 class="school-name"><?php echo htmlspecialchars($school_settings['school_name'] ?? 'School Name'); ?></h1>
            <?php endif; ?>
            <div class="school-info">
                <?php echo htmlspecialchars($school_settings['address'] ?? 'School Address'); ?><br>
                Phone: <?php echo htmlspecialchars($school_settings['phone'] ?? 'N/A'); ?> | Email: <?php echo htmlspecialchars($school_settings['email'] ?? 'N/A'); ?>
            </div>
        </div>

        <div class="class-header">
            <h2 class="class-title">Class: <?php echo htmlspecialchars($class); ?></h2>
            <div class="student-count">Total Students: <?php echo count($students); ?></div>
        </div>

        <table class="students-table">
            <thead>
                <tr>
                    <th>Photo</th>
                    <th>Student ID</th>
                    <th>Name</th>
                    <th>Gender</th>
                    <th>Date of Birth</th>
                    <th>Nationality</th>
                    <th>Phone</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($students as $student): ?>
                    <tr>
                        <td>
                            <?php if (!empty($student['photo_path'])): ?>
                                <img src="../<?php echo htmlspecialchars($student['photo_path']); ?>" alt="Photo" class="student-photo">
                            <?php else: ?>
                                <div class="no-photo">N/A</div>
                            <?php endif; ?>
                        </td>
                        <td><?php echo htmlspecialchars($student['student_id'] ?? $student['id']); ?></td>
                        <td><?php echo htmlspecialchars(trim(($student['last_name'] ?? '') . ' ' . ($student['middle_name'] ?? '') . ' ' . ($student['first_name'] ?? ''))); ?></td>
                        <td><?php echo htmlspecialchars($student['gender'] ?? ''); ?></td>
                        <td><?php echo htmlspecialchars($student['dob'] ?? ''); ?></td>
                        <td><?php echo htmlspecialchars($student['nationality'] ?? ''); ?></td>
                        <td><?php echo htmlspecialchars($student['phone'] ?? ''); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
