<?php
require_once __DIR__ . '/../config.php';

try {
    // Create staff_users table
    $sql = "CREATE TABLE IF NOT EXISTS staff_users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        username VARCHAR(100) NOT NULL UNIQUE,
        password VARCHAR(255) NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )";

    $pdo->exec($sql);
    echo "Staff users table created successfully.\n";

    // Check if staff table has user_id column, if not add it
    try {
        $pdo->exec("ALTER TABLE staff ADD COLUMN user_id INT NULL");
        echo "Added user_id column to staff table.\n";
    } catch (Exception $e) {
        if (strpos($e->getMessage(), 'Duplicate column name') === false) {
            throw $e;
        }
        // Column already exists, skip
    }

    // Migrate existing staff users from users table to staff_users table
    try {
        // Get all staff users from users table (excluding students)
        $stmt = $pdo->query("SELECT id, username, password FROM users WHERE role != 'student'");
        $staffUsers = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (!empty($staffUsers)) {
            echo "Migrating " . count($staffUsers) . " staff users...\n";

            foreach ($staffUsers as $user) {
                // Insert into staff_users
                $stmt = $pdo->prepare("INSERT INTO staff_users (username, password, created_at) VALUES (?, ?, NOW())");
                $stmt->execute([$user['username'], $user['password']]);

                $newUserId = $pdo->lastInsertId();

                // Update staff table to reference new staff_users.id if staff record exists
                $stmt = $pdo->prepare("UPDATE staff SET user_id = ? WHERE username = ?");
                $stmt->execute([$newUserId, $user['username']]);

                echo "Migrated user: {$user['username']} (old ID: {$user['id']}, new ID: {$newUserId})\n";
            }

            // Optionally remove migrated staff records from users table
            // Uncomment the following lines if you want to remove them
            /*
            $stmt = $pdo->prepare("DELETE FROM users WHERE role != 'student'");
            $stmt->execute();
            echo "Removed migrated staff records from users table.\n";
            */
        } else {
            echo "No staff users found to migrate.\n";
        }
    } catch (Exception $e) {
        echo "Error during migration: " . $e->getMessage() . "\n";
    }

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
