<?php

function log_message($message, $level = 'INFO') {
    $log_file = __DIR__ . '/../logs/app.log';
    if (!is_dir(dirname($log_file))) {
        mkdir(dirname($log_file), 0755, true);
    }
    $timestamp = date('Y-m-d H:i:s');
    $log_entry = "[$timestamp] [$level] $message" . PHP_EOL;
    file_put_contents($log_file, $log_entry, FILE_APPEND);
}

class Logger {
    private $level;

    public function __construct($level = 'INFO') {
        $this->level = $level;
    }

    public function info($message) {
        log_message($message, 'INFO');
    }

    public function error($message) {
        log_message($message, 'ERROR');
    }

    public function warning($message) {
        log_message($message, 'WARNING');
    }
}

function setup_logger($level = 'INFO') {
    return new Logger($level);
}

?>
