<?php
require_once '../config.php';

try {
    echo "Renaming 'Expenses' category to 'Miscellaneous Expenses'...\n";

    // Check current category
    $stmt = $pdo->prepare("SELECT id, name, type, is_system FROM budget_categories WHERE id = ?");
    $stmt->execute([18]);
    $category = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$category) {
        echo "Error: Expenses category (ID 18) not found.\n";
        exit(1);
    }

    echo "Current category: {$category['name']} (ID: {$category['id']}, Type: {$category['type']}, System: " . ($category['is_system'] ? 'Yes' : 'No') . ")\n";

    // Rename the category
    $stmt = $pdo->prepare("UPDATE budget_categories SET name = ? WHERE id = ? AND is_system = TRUE");
    $stmt->execute(['Miscellaneous Expenses', 18]);

    if ($stmt->rowCount() > 0) {
        echo "Successfully renamed category to 'Miscellaneous Expenses'\n";

        // Verify the change
        $stmt = $pdo->prepare("SELECT id, name FROM budget_categories WHERE id = ?");
        $stmt->execute([18]);
        $updated = $stmt->fetch(PDO::FETCH_ASSOC);

        echo "Verification: Category is now named '{$updated['name']}'\n";
    } else {
        echo "Error: Could not rename category. It may not be a system category or may not exist.\n";
    }

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
    exit(1);
}
?>
