<?php
require_once '../config.php';

try {
    $pdo->beginTransaction();

    // Check if account 2090 has any journal entry lines
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM journal_entry_lines WHERE account_id = (SELECT id FROM chart_of_accounts WHERE account_code = '2090')");
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "Account 2090 has {$result['count']} journal entry lines.\n";

    if ($result['count'] > 0) {
        echo "Cannot delete account 2090 - it has {$result['count']} journal entry lines. Please transfer balances first.\n";
        $pdo->rollBack();
        exit;
    }

    // Check if account 2090 has any balances
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM account_balances WHERE account_id = (SELECT id FROM chart_of_accounts WHERE account_code = '2090')");
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "Account 2090 has {$result['count']} balance records.\n";

    if ($result['count'] > 0) {
        echo "Cannot delete account 2090 - it has balances. Please transfer balances first.\n";
        $pdo->rollBack();
        exit;
    }

    // Safe to delete
    $stmt = $pdo->prepare("DELETE FROM chart_of_accounts WHERE account_code = '2090'");
    $stmt->execute();

    $pdo->commit();
    echo "Account 2090 PAYE Payable has been successfully removed.\n";

} catch (Exception $e) {
    $pdo->rollBack();
    echo 'Error: ' . $e->getMessage() . "\n";
}
?>
