<?php
require_once '../config.php';

try {
    // Update categories for Asset accounts
    $stmt = $pdo->prepare("
        UPDATE chart_of_accounts
        SET category = CASE
            WHEN CAST(account_code AS UNSIGNED) < 1200 THEN 'current_asset'
            WHEN CAST(account_code AS UNSIGNED) >= 1200 AND CAST(account_code AS UNSIGNED) < 1300 THEN 'fixed_asset'
            ELSE 'other_asset'
        END
        WHERE account_type = 'Asset'
    ");
    $stmt->execute();
    $assetCount = $stmt->rowCount();

    // Update Equity accounts
    $stmt = $pdo->prepare("
        UPDATE chart_of_accounts
        SET category = 'equity'
        WHERE account_code IN ('3000', '3010', '3020', '3030')
    ");
    $stmt->execute();
    $equityCount = $stmt->rowCount();

    // Update categories for Liability accounts
    $stmt = $pdo->prepare("
        UPDATE chart_of_accounts
        SET category = CASE
            WHEN account_code < '3000' THEN 'current_liability'
            ELSE 'long_term_liability'
        END
        WHERE account_type = 'Liability'
    ");
    $stmt->execute();
    $liabilityCount = $stmt->rowCount();

    // Update categories for Equity accounts
    $stmt = $pdo->prepare("
        UPDATE chart_of_accounts
        SET category = 'equity'
        WHERE account_type = 'Equity'
    ");
    $stmt->execute();
    $equityCount = $stmt->rowCount();

    echo "Category population completed successfully!\n";
    echo "Updated $assetCount Asset accounts\n";
    echo "Updated $liabilityCount Liability accounts\n";
    echo "Updated $equityCount Equity accounts\n";

    // Verify the updates
    $stmt = $pdo->prepare("
        SELECT account_type, category, COUNT(*) as count
        FROM chart_of_accounts
        WHERE category IS NOT NULL
        GROUP BY account_type, category
        ORDER BY account_type, category
    ");
    $stmt->execute();
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "\nVerification of category assignments:\n";
    foreach ($results as $result) {
        echo "{$result['account_type']} - {$result['category']}: {$result['count']} accounts\n";
    }

} catch (PDOException $e) {
    echo "Error populating categories: " . $e->getMessage();
}
?>
