<?php
require_once '../config.php';

$message = '';
$error = '';

try {
    // Read the SQL file
    $sql = file_get_contents('create_purchase_orders_tables.sql');

    // Split into individual statements
    $statements = array_filter(array_map('trim', explode(';', $sql)));

    $pdo->beginTransaction();

    foreach ($statements as $statement) {
        if (!empty($statement)) {
            $pdo->exec($statement);
        }
    }

    $pdo->commit();
    $message = "Purchase Orders tables created successfully!";

} catch (PDOException $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    $error = "Error creating tables: " . $e->getMessage();
} catch (Exception $e) {
    $error = "Error reading SQL file: " . $e->getMessage();
}

echo $message ?: $error;
?>
