<style>
    .admin-sidebar {
        width: 280px;
        background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
        color: #fff;
        padding: 0;
        position: fixed;
        height: 100vh;
        overflow-y: auto;
        box-shadow: 2px 0 10px rgba(0,0,0,0.1);
        z-index: 1000;
        font-size: 0.85rem;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        transition: background-color 0.3s ease;
    }

    .sidebar-header {
        padding: 25px 20px 15px;
        border-bottom: 1px solid rgba(255,255,255,0.1);
        background: rgba(255,255,255,0.05);
    }

    .admin-sidebar h3 {
        margin: 0;
        color: #fff;
        font-size: 1.3em;
        font-weight: 700;
        text-align: center;
        letter-spacing: 1.5px;
        text-transform: uppercase;
        animation: fadeInDown 0.8s ease forwards;
    }

    .sidebar-menu {
        list-style: none;
        padding: 15px 0;
        margin: 0;
    }

    .menu-item {
        margin-bottom: 5px;
    }

    .menu-link {
        color: #ecf0f1;
        text-decoration: none;
        display: flex;
        align-items: center;
        padding: 15px 20px;
        border-radius: 0;
        transition: all 0.3s ease;
        position: relative;
        border-left: 4px solid transparent;
    }

    .menu-link:hover {
        background-color: rgba(255,255,255,0.1);
        color: #fff;
        border-left-color: #3498db;
        text-decoration: none;
    }

    .menu-link.active {
        background-color: rgba(52, 152, 219, 0.2);
        color: #fff;
        border-left-color: #3498db;
    }

    .menu-icon {
        font-size: 1.2em;
        margin-right: 15px;
        width: 25px;
        text-align: center;
        display: inline-block;
    }

    .menu-text {
        font-weight: 500;
        font-size: 0.95em;
        letter-spacing: 0.5px;
    }

    .logout-item .menu-link {
        margin-top: 20px;
        border-top: 1px solid rgba(255,255,255,0.1);
        padding-top: 20px;
    }

    .logout-item .menu-link:hover {
        background-color: rgba(231, 76, 60, 0.8);
        border-left-color: #e74c3c;
    }

    /* Submenu styles */
    .has-submenu .submenu {
        list-style: none;
        padding: 0;
        margin: 0;
        background-color: rgba(0,0,0,0.1);
        max-height: 0;
        overflow: hidden;
        transition: max-height 0.3s ease;
    }

    .has-submenu .submenu-toggle {
        position: relative;
    }

    .submenu-arrow {
        margin-left: auto;
        transition: transform 0.3s ease;
    }

    .has-submenu.open .submenu-arrow {
        transform: rotate(90deg);
    }

    .has-submenu.open .submenu {
        max-height: 1000px;
    }

    /* Sub-submenu styles */
    .has-submenu .has-submenu .submenu {
        background-color: rgba(0,0,0,0.2);
    }

    .has-submenu .has-submenu .submenu-link {
        padding-left: 80px;
    }

    .submenu-link {
        background-color: rgba(135, 206, 235, 0.1);
        color: #bdc3c7;
        text-decoration: none;
        display: block;
        padding: 10px 20px 10px 60px;
        font-size: 0.9em;
        transition: all 0.3s ease;
    }

    .submenu-link:hover {
        background-color: rgba(255,255,255,0.1);
        color: #fff;
        text-decoration: none;
    }

    .submenu-link.active {
        background-color: rgba(52, 152, 219, 0.3);
        color: #fff;
        border-left: 3px solid #3498db;
    }

    /* Keyframes for animations */
    @keyframes fadeInDown {
        from {
            opacity: 0;
            transform: translateY(-20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Responsive */
    @media (max-width: 768px) {
        .admin-sidebar {
            transform: translateX(-100%);
            transition: transform 0.3s;
            z-index: 999;
        }

        .admin-sidebar.open {
            transform: translateX(0);
        }
    }
</style>

<?php
// Use access control system to get accessible menu items
require_once 'enhanced_access_control_fixed.php';
$accessible_menu_items = getAccessibleMenuItems();
$current_page = basename($_SERVER['PHP_SELF']);
?>

<div class="admin-sidebar">
    <div class="sidebar-header">
        <h3>🏫 Admin Panel</h3>
    </div>
    <ul class="sidebar-menu">
        <!-- Dashboard -->
        <?php if (isset($accessible_menu_items['dashboard'])): ?>
        <li class="menu-item">
            <?php if ($_SESSION['role'] == 'head_teacher'): ?>
            <a href="headteacher_dashboard.php" class="menu-link<?php if ($current_page == 'headteacher_dashboard.php') echo ' active'; ?>">
                <span class="menu-icon">📊</span>
                <span class="menu-text">Head Teacher Dashboard</span>
            </a>
            <?php else: ?>
            <a href="admin_dashboard.php" class="menu-link<?php if ($current_page == 'admin_dashboard.php') echo ' active'; ?>">
                <span class="menu-icon">📊</span>
                <span class="menu-text"><?php echo $accessible_menu_items['dashboard']['name']; ?></span>
            </a>
            <?php endif; ?>
        </li>
        <?php endif; ?>

        <!-- User Management -->
        <?php if (isset($accessible_menu_items['user_management'])): ?>
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon">👥</span>
                <span class="menu-text"><?php echo $accessible_menu_items['user_management']['name']; ?></span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <li>
                    <a href="user_management.php" class="submenu-link<?php if ($current_page == 'user_management.php') echo ' active'; ?>">
                        Manage Users
                    </a>
                </li>
                <li>
                    <a href="user_logs.php" class="submenu-link<?php if ($current_page == 'user_logs.php') echo ' active'; ?>">
                        📋 User Activity Logs
                    </a>
                </li>
            </ul>
        </li>
        <?php endif; ?>

        <!-- Roles & Permissions -->
        <?php if (isset($accessible_menu_items['roles_permissions'])): ?>
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon">🔐</span>
                <span class="menu-text"><?php echo $accessible_menu_items['roles_permissions']['name']; ?></span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <?php if (isset($accessible_menu_items['roles_permissions']['submenu']['manage_roles'])): ?>
                <li>
                    <a href="manage_roles.php" class="submenu-link<?php if ($current_page == 'manage_roles.php') echo ' active'; ?>">
                        <?php echo $accessible_menu_items['roles_permissions']['submenu']['manage_roles']['name']; ?>
                    </a>
                </li>
                <?php endif; ?>
                <?php if (isset($accessible_menu_items['roles_permissions']['submenu']['manage_user_roles'])): ?>
                <li>
                    <a href="manage_user_roles.php" class="submenu-link<?php if ($current_page == 'manage_user_roles.php') echo ' active'; ?>">
                        <?php echo $accessible_menu_items['roles_permissions']['submenu']['manage_user_roles']['name']; ?>
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </li>
        <?php endif; ?>

        <!-- Students -->
        <?php if (isset($accessible_menu_items['students'])): ?>
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon">👨‍🎓</span>
                <span class="menu-text"><?php echo $accessible_menu_items['students']['name']; ?></span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <?php if (isset($accessible_menu_items['students']['submenu']['enroll_students'])): ?>
                <li>
                    <a href="enroll_students.php" class="submenu-link<?php if ($current_page == 'enroll_students.php') echo ' active'; ?>">
                        <?php echo $accessible_menu_items['students']['submenu']['enroll_students']['name']; ?>
                    </a>
                </li>
                <?php endif; ?>
                <?php if (isset($accessible_menu_items['students']['submenu']['manage_students'])): ?>
                <li>
                    <a href="manage_students.php" class="submenu-link<?php if ($current_page == 'manage_students.php') echo ' active'; ?>">
                        <?php echo $accessible_menu_items['students']['submenu']['manage_students']['name']; ?>
                    </a>
                </li>
                <?php endif; ?>
                <?php if (isset($accessible_menu_items['students']['submenu']['student_logins'])): ?>
                <li>
                    <a href="manage_student_logins.php" class="submenu-link<?php if ($current_page == 'manage_student_logins.php') echo ' active'; ?>">
                        <?php echo $accessible_menu_items['students']['submenu']['student_logins']['name']; ?>
                    </a>
                </li>
                <?php endif; ?>
                <?php if (isset($accessible_menu_items['students']['submenu']['promote_students'])): ?>
                <li>
                    <a href="promote_students.php" class="submenu-link<?php if ($current_page == 'promote_students.php') echo ' active'; ?>">
                        <?php echo $accessible_menu_items['students']['submenu']['promote_students']['name']; ?>
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </li>
        <?php endif; ?>

        <!-- Classes -->
        <?php if (isset($accessible_menu_items['classes'])): ?>
        <li class="menu-item">
            <a href="view_classes.php" class="menu-link<?php if ($current_page == 'view_classes.php') echo ' active'; ?>">
                <span class="menu-icon">🏫</span>
                <span class="menu-text"><?php echo $accessible_menu_items['classes']['name']; ?></span>
            </a>
        </li>
        <?php endif; ?>

        <!-- Courses / Subjects -->
        <?php if (isset($accessible_menu_items['courses'])): ?>
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon">📚</span>
                <span class="menu-text"><?php echo $accessible_menu_items['courses']['name']; ?></span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <?php if (isset($accessible_menu_items['courses']['submenu']['manage_courses'])): ?>
                <li>
                    <a href="manage_courses.php" class="submenu-link<?php if ($current_page == 'manage_courses.php') echo ' active'; ?>">
                        <?php echo $accessible_menu_items['courses']['submenu']['manage_courses']['name']; ?>
                    </a>
                </li>
                <?php endif; ?>
                <?php if (isset($accessible_menu_items['courses']['submenu']['view_subjects'])): ?>
                <li>
                    <a href="subjects.php" class="submenu-link<?php if ($current_page == 'subjects.php') echo ' active'; ?>">
                        <?php echo $accessible_menu_items['courses']['submenu']['view_subjects']['name']; ?>
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </li>
        <?php endif; ?>

        <!-- Staff -->
        <?php if (isset($accessible_menu_items['staff'])): ?>
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon">👥</span>
                <span class="menu-text"><?php echo $accessible_menu_items['staff']['name']; ?></span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <?php if (isset($accessible_menu_items['staff']['submenu']['teachers'])): ?>
                <li class="has-submenu">
                    <a href="#" class="submenu-link submenu-toggle">
                        <span class="menu-text"><?php echo $accessible_menu_items['staff']['submenu']['teachers']['name']; ?></span>
                        <span class="submenu-arrow">▸</span>
                    </a>
                    <ul class="submenu">
                        <?php if (isset($accessible_menu_items['staff']['submenu']['teachers']['submenu']['manage_teachers'])): ?>
                        <li>
                            <a href="manage_teachers.php" class="submenu-link<?php if ($current_page == 'manage_teachers.php') echo ' active'; ?>">
                                <?php echo $accessible_menu_items['staff']['submenu']['teachers']['submenu']['manage_teachers']['name']; ?>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (isset($accessible_menu_items['staff']['submenu']['teachers']['submenu']['assign_class'])): ?>
                        <li>
                            <a href="assign_class.php" class="submenu-link<?php if ($current_page == 'assign_class.php') echo ' active'; ?>">
                                <?php echo $accessible_menu_items['staff']['submenu']['teachers']['submenu']['assign_class']['name']; ?>
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>
                <?php if (isset($accessible_menu_items['staff']['submenu']['librarians'])): ?>
                <li>
                    <a href="manage_librarians.php" class="submenu-link<?php if ($current_page == 'manage_librarians.php') echo ' active'; ?>">
                        <?php echo $accessible_menu_items['staff']['submenu']['librarians']['name']; ?>
                    </a>
                </li>
                <?php endif; ?>
                <?php if (isset($accessible_menu_items['staff']['submenu']['non_teaching'])): ?>
                <li>
                    <a href="manage_non_teaching.php" class="submenu-link<?php if ($current_page == 'manage_non_teaching.php') echo ' active'; ?>">
                        <?php echo $accessible_menu_items['staff']['submenu']['non_teaching']['name']; ?>
                    </a>
                </li>
                <?php endif; ?>
                <?php if (isset($accessible_menu_items['staff']['submenu']['directors'])): ?>
                <li>
                    <a href="manage_directors.php" class="submenu-link<?php if ($current_page == 'manage_directors.php') echo ' active'; ?>">
                        <?php echo $accessible_menu_items['staff']['submenu']['directors']['name']; ?>
                    </a>
                </li>
                <?php endif; ?>
                <?php if (isset($accessible_menu_items['staff']['submenu']['head_teachers'])): ?>
                <li>
                    <a href="manage_head_teachers.php" class="submenu-link<?php if ($current_page == 'manage_head_teachers.php') echo ' active'; ?>">
                        <?php echo $accessible_menu_items['staff']['submenu']['head_teachers']['name']; ?>
                    </a>
                </li>
                <?php endif; ?>
                <?php if (isset($accessible_menu_items['staff']['submenu']['leave_management'])): ?>
                <li>
                    <a href="manage_staff_leaves.php" class="submenu-link<?php if ($current_page == 'manage_staff_leaves.php') echo ' active'; ?>">
                        <?php echo $accessible_menu_items['staff']['submenu']['leave_management']['name']; ?>
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </li>
        <?php endif; ?>

        <!-- Discussion Management - Only for head teachers -->
        <?php if ($_SESSION['role'] == 'head_teacher'): ?>
        <li class="menu-item">
            <a href="headteacher_discussion.php" class="menu-link<?php if ($current_page == 'headteacher_discussion.php') echo ' active'; ?>">
                <span class="menu-icon">💬</span>
                <span class="menu-text">Discussion Management</span>
            </a>
        </li>
        <?php endif; ?>



        <!-- Academic Management -->
        <?php if (isset($accessible_menu_items['academic'])): ?>
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon">📅</span>
                <span class="menu-text">Academic Management</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <?php if (isset($accessible_menu_items['academic']['submenu']['academic_years'])): ?>
                <li>
                    <a href="manage_academic_years.php" class="submenu-link<?php if ($current_page == 'manage_academic_years.php') echo ' active'; ?>">
                        <?php echo $accessible_menu_items['academic']['submenu']['academic_years']['name']; ?>
                    </a>
                </li>
                <?php endif; ?>
                <?php if (isset($accessible_menu_items['academic']['submenu']['terms'])): ?>
                <li>
                    <a href="manage_terms.php" class="submenu-link<?php if ($current_page == 'manage_terms.php') echo ' active'; ?>">
                        <?php echo $accessible_menu_items['academic']['submenu']['terms']['name']; ?>
                    </a>
                </li>
                <?php endif; ?>
                <?php if (isset($accessible_menu_items['academic']['submenu']['levels'])): ?>
                <li>
                    <a href="manage_levels.php" class="submenu-link<?php if ($current_page == 'manage_levels.php') echo ' active'; ?>">
                        <?php echo $accessible_menu_items['academic']['submenu']['levels']['name']; ?>
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </li>
        <?php endif; ?>





        <!-- Facilities -->
        <?php if (isset($accessible_menu_items['facilities'])): ?>
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon">🏢</span>
                <span class="menu-text">Facilities</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <?php if (isset($accessible_menu_items['facilities']['submenu']['manage_facilities'])): ?>
                <li>
                    <a href="manage_facilities.php" class="submenu-link<?php if ($current_page == 'manage_facilities.php') echo ' active'; ?>">
                        <?php echo $accessible_menu_items['facilities']['submenu']['manage_facilities']['name']; ?>
                    </a>
                </li>
                <?php endif; ?>
                <?php if (isset($accessible_menu_items['facilities']['submenu']['booking_management'])): ?>
                <li>
                    <a href="manage_bookings.php" class="submenu-link<?php if ($current_page == 'manage_bookings.php') echo ' active'; ?>">
                        <?php echo $accessible_menu_items['facilities']['submenu']['booking_management']['name']; ?>
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </li>
        <?php endif; ?>

        <!-- Transportation -->
        <?php if (isset($accessible_menu_items['transportation'])): ?>
        <li class="menu-item">
            <a href="manage_transportation.php" class="menu-link<?php if ($current_page == 'manage_transportation.php') echo ' active'; ?>">
                <span class="menu-icon">🚌</span>
                <span class="menu-text">Transportation</span>
            </a>
        </li>
        <?php endif; ?>

        <!-- System -->
        <?php if (isset($accessible_menu_items['system'])): ?>
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon">⚙️</span>
                <span class="menu-text">System</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <?php if (isset($accessible_menu_items['system']['submenu']['grading_system'])): ?>
                <li>
                    <a href="manage_grading_system.php" class="submenu-link<?php if ($current_page == 'manage_grading_system.php') echo ' active'; ?>">
                        <?php echo $accessible_menu_items['system']['submenu']['grading_system']['name']; ?>
                    </a>
                </li>
                <?php endif; ?>
                <?php if (isset($accessible_menu_items['system']['submenu']['settings'])): ?>
                <li>
                    <a href="settings.php" class="submenu-link<?php if ($current_page == 'settings.php') echo ' active'; ?>">
                        <?php echo $accessible_menu_items['system']['submenu']['settings']['name']; ?>
                    </a>
                </li>
                <?php endif; ?>
                <?php if (hasPermission('settings')): ?>
                <li>
                    <a href="create_advanced_accounting_tables.sql" class="submenu-link<?php if ($current_page == 'create_advanced_accounting_tables.sql') echo ' active'; ?>">
                        Database Setup
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </li>
        <?php endif; ?>

        <!-- Logout is always visible -->
        <li class="menu-item logout-item">
            <a href="../logout.php" class="menu-link">
                <span class="menu-icon">🚪</span>
                <span class="menu-text">Logout</span>
            </a>
        </li>
    </ul>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const submenuToggles = document.querySelectorAll('.submenu-toggle');
        const mobileMenuToggle = document.getElementById('mobile-menu-toggle');
        const adminSidebar = document.querySelector('.admin-sidebar');

        // Ensure all submenus start closed
        const allSubmenus = document.querySelectorAll('.has-submenu');
        allSubmenus.forEach(submenu => {
            submenu.classList.remove('open');
        });

        submenuToggles.forEach(toggle => {
            toggle.addEventListener('click', function(e) {
                e.preventDefault();
                const parentItem = this.closest('.has-submenu');

                // Close all other submenus at the same level
                const siblings = parentItem.parentElement.querySelectorAll('.has-submenu');
                siblings.forEach(sibling => {
                    if (sibling !== parentItem) {
                        sibling.classList.remove('open');
                    }
                });

                // For submenu items (like Teachers), close all their nested submenus
                const allNestedSubmenus = parentItem.querySelectorAll('.has-submenu');
                allNestedSubmenus.forEach(submenu => {
                    submenu.classList.remove('open');
                });

                parentItem.classList.toggle('open');
            });
        });

        if (mobileMenuToggle && adminSidebar) {
            mobileMenuToggle.addEventListener('click', function() {
                adminSidebar.classList.toggle('open');
            });
        }
    });
</script>
