<style>
    .accounting-sidebar {
        width: 280px;
        background: linear-gradient(135deg, #2E7D32 0%, #4CAF50 100%);
        color: #fff;
        padding: 0;
        position: fixed;
        height: 100vh;
        overflow-y: auto;
        box-shadow: 2px 0 10px rgba(0,0,0,0.1);
        z-index: 1000;
        font-size: 0.85rem;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        transition: background-color 0.3s ease;
    }

    .sidebar-header {
        padding: 25px 20px 15px;
        border-bottom: 1px solid rgba(255,255,255,0.1);
        background: rgba(255,255,255,0.05);
    }

    .accounting-sidebar h3 {
        margin: 0;
        color: #fff;
        font-size: 1.3em;
        font-weight: 700;
        text-align: center;
        letter-spacing: 1.5px;
        text-transform: uppercase;
        animation: fadeInDown 0.8s ease forwards;
    }

    .sidebar-menu {
        list-style: none;
        padding: 15px 0;
        margin: 0;
    }

    .menu-item {
        margin-bottom: 5px;
    }

    .menu-link {
        color: #ecf0f1;
        text-decoration: none;
        display: flex;
        align-items: center;
        padding: 15px 20px;
        border-radius: 0;
        transition: all 0.3s ease;
        position: relative;
        border-left: 4px solid transparent;
    }

    .menu-link:hover {
        background-color: rgba(249, 168, 37, 0.2);
        color: #fff;
        border-left-color: #F9A825;
        text-decoration: none;
    }

    .menu-link.active {
        background-color: rgba(249, 168, 37, 0.3);
        color: #fff;
        border-left-color: #F9A825;
    }

    .menu-icon {
        font-size: 1.2em;
        margin-right: 15px;
        width: 25px;
        text-align: center;
        display: inline-block;
    }

    .menu-text {
        font-weight: 500;
        font-size: 0.95em;
        letter-spacing: 0.5px;
    }

    .logout-item .menu-link {
        margin-top: 20px;
        border-top: 1px solid rgba(255,255,255,0.1);
        padding-top: 20px;
    }

    .logout-item .menu-link:hover {
        background-color: rgba(231, 76, 60, 0.8);
        border-left-color: #e74c3c;
    }

    /* Submenu styles */
    .has-submenu .submenu {
        list-style: none;
        padding: 0;
        margin: 0;
        background-color: rgba(0,0,0,0.1);
        max-height: 0;
        overflow: hidden;
        transition: max-height 0.3s ease;
    }

    .has-submenu .submenu-toggle {
        position: relative;
    }

    .submenu-arrow {
        margin-left: auto;
        transition: transform 0.3s ease;
    }

    .has-submenu.open .submenu-arrow {
        transform: rotate(90deg);
    }

    .has-submenu.open .submenu {
        max-height: 1000px;
    }

    .submenu-link {
        background-color: rgba(249, 168, 37, 0.1);
        color: #bdc3c7;
        text-decoration: none;
        display: block;
        padding: 10px 20px 10px 60px;
        font-size: 0.9em;
        transition: all 0.3s ease;
    }

    .submenu-link:hover {
        background-color: rgba(249, 168, 37, 0.2);
        color: #fff;
        text-decoration: none;
    }

    .submenu-link.active {
        background-color: rgba(249, 168, 37, 0.4);
        color: #fff;
        border-left: 3px solid #F9A825;
    }

    /* Keyframes for animations */
    @keyframes fadeInDown {
        from {
            opacity: 0;
            transform: translateY(-20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Responsive */
    @media (max-width: 768px) {
        .accounting-sidebar {
            transform: translateX(-100%);
            transition: transform 0.3s;
            z-index: 999;
        }

        .accounting-sidebar.open {
            transform: translateX(0);
        }
    }
</style>

<?php
$current_page = basename($_SERVER['PHP_SELF']);
?>

<div class="accounting-sidebar">
    <div class="sidebar-header">
        <h3><i class="fas fa-calculator"></i> Accounting</h3>
    </div>
    <ul class="sidebar-menu">
        <!-- Dashboard -->
        <li class="menu-item">
            <a href="accounting_dashboard.php" class="menu-link<?php if ($current_page == 'accounting_dashboard.php') echo ' active'; ?>">
                <span class="menu-icon"><i class="fas fa-chart-line"></i></span>
                <span class="menu-text">Dashboard</span>
            </a>
        </li>

        <!-- Fee Management -->
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon"><i class="fas fa-money-bill-wave"></i></span>
                <span class="menu-text">Fee Management</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <li>
                    <a href="add_fee.php" class="submenu-link<?php if ($current_page == 'add_fee.php') echo ' active'; ?>">
                        Create Fees
                    </a>
                </li>
                <li>
                    <a href="assign_fees.php" class="submenu-link<?php if ($current_page == 'assign_fees.php') echo ' active'; ?>">
                        Assign Fees
                    </a>
                </li>
                <li>
                    <a href="record_payments.php" class="submenu-link<?php if ($current_page == 'record_payments.php') echo ' active'; ?>">
                        Record Payments
                    </a>
                </li>
            </ul>
        </li>

        <!-- Income Management -->
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon"><i class="fas fa-coins"></i></span>
                <span class="menu-text">Income Management</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <li>
                    <a href="manage_incomes.php" class="submenu-link<?php if ($current_page == 'manage_incomes.php') echo ' active'; ?>">
                        Manage Incomes
                    </a>
                </li>
                <li>
                    <a href="add_income.php" class="submenu-link<?php if ($current_page == 'add_income.php') echo ' active'; ?>">
                        Add Income
                    </a>
                </li>
            </ul>
        </li>

        <!-- Expenses -->
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon"><i class="fas fa-credit-card"></i></span>
                <span class="menu-text">Expenses</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <li>
                    <a href="record_expense.php" class="submenu-link<?php if ($current_page == 'record_expense.php') echo ' active'; ?>">
                        Record Expense
                    </a>
                </li>
                <li>
                    <a href="expense_list.php" class="submenu-link<?php if ($current_page == 'expense_list.php') echo ' active'; ?>">
                        Expense List
                    </a>
                </li>
                <li>
                    <a href="pay_expenses.php" class="submenu-link<?php if ($current_page == 'pay_expenses.php') echo ' active'; ?>">
                        Pay Expenses
                    </a>
                </li>
            </ul>
        </li>
        
         <!-- Procurement -->
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon"><i class="fas fa-shopping-cart"></i></span>
                <span class="menu-text">Procurement</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <li>
                    <a href="manage_suppliers.php" class="submenu-link<?php if ($current_page == 'manage_suppliers.php') echo ' active'; ?>">
                        Manage Suppliers
                    </a>
                </li>
                <li>
                    <a href="purchase_orders.php" class="submenu-link<?php if ($current_page == 'purchase_orders.php') echo ' active'; ?>">
                        Purchase Orders
                    </a>
                </li>
                <li>
                    <a href="approve_po.php" class="submenu-link<?php if ($current_page == 'approve_po.php') echo ' active'; ?>">
                        Approve PO
                    </a>
                </li>
                <li>
                    <a href="receive_po.php" class="submenu-link<?php if ($current_page == 'receive_po.php') echo ' active'; ?>">
                        Receive Purchase Orders
                    </a>
                </li>
                <li>
                    <a href="supplier_invoices.php" class="submenu-link<?php if ($current_page == 'supplier_invoices.php') echo ' active'; ?>">
                        Supplier Invoices
                    </a>
                </li>
                <li>
                    <a href="approve_invoices.php" class="submenu-link<?php if ($current_page == 'approve_invoices.php') echo ' active'; ?>">
                        Approve Supplier Invoices
                    </a>
                </li>
                <li>
                    <a href="po_payments.php" class="submenu-link<?php if ($current_page == 'po_payments.php') echo ' active'; ?>">
                        Purchase Order Payments
                    </a>
                </li>
            </ul>
        </li>

        <!-- Assets Management -->
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon"><i class="fas fa-building"></i></span>
                <span class="menu-text">Assets Management</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <li>
                    <a href="manage_assets.php" class="submenu-link<?php if ($current_page == 'manage_assets.php') echo ' active'; ?>">
                        Manage Assets
                    </a>
                </li>
                <li>
                    <a href="add_asset.php" class="submenu-link<?php if ($current_page == 'add_asset.php') echo ' active'; ?>">
                        Add Asset
                    </a>
                </li>
            </ul>
        </li>

        <!-- Loans & Liabilities -->
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon"><i class="fas fa-hand-holding-usd"></i></span>
                <span class="menu-text">Loans & Liabilities</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <li>
                    <a href="manage_loans.php" class="submenu-link<?php if ($current_page == 'manage_loans.php') echo ' active'; ?>">
                        Manage Loans
                    </a>
                </li>
                <li>
                    <a href="loan_payment_history.php" class="submenu-link<?php if ($current_page == 'loan_payment_history.php') echo ' active'; ?>">
                        Loan Payment History
                    </a>
                </li>
                <li>
                    <a href="manage_staff_loans.php" class="submenu-link<?php if ($current_page == 'manage_staff_loans.php') echo ' active'; ?>">
                        Staff Loans
                    </a>
                </li>
            </ul>
        </li>

        <!-- Financial Operations -->
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon"><i class="fas fa-exchange-alt"></i></span>
                <span class="menu-text">Financial Operations</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <li>
                    <a href="transfer_funds.php" class="submenu-link<?php if ($current_page == 'transfer_funds.php') echo ' active'; ?>">
                        Transfer Funds
                    </a>
                </li>
                <!-- Budget Management -->
                <li class="has-submenu">
                    <a href="#" class="submenu-link submenu-toggle">
                        <span class="menu-text">Budget Management</span>
                        <span class="submenu-arrow">▸</span>
                    </a>
                    <ul class="submenu">
                        <li>
                            <a href="manage_budgets.php" class="submenu-link<?php if ($current_page == 'manage_budgets.php') echo ' active'; ?>">
                                Manage Budgets
                            </a>
                        </li>
                        <li>
                            <a href="budget_vs_actual_report.php" class="submenu-link<?php if ($current_page == 'budget_vs_actual_report.php') echo ' active'; ?>">
                                Budget vs Actual
                            </a>
                        </li>
                    </ul>
                </li>
            </ul>
        </li>

        <!-- Payroll Management -->
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon"><i class="fas fa-money-check"></i></span>
                <span class="menu-text">Payroll Management</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <li>
                    <a href="payroll_management.php" class="submenu-link<?php if ($current_page == 'payroll_management.php') echo ' active'; ?>">
                        Payroll Dashboard
                    </a>
                </li>
                <li>
                    <a href="manage_salary_structures.php" class="submenu-link<?php if ($current_page == 'manage_salary_structures.php') echo ' active'; ?>">
                        Salary Structures
                    </a>
                </li>
                <li>
                    <a href="manage_allowances.php" class="submenu-link<?php if ($current_page == 'manage_allowances.php') echo ' active'; ?>">
                        Setup Allowances
                    </a>
                </li>
                <li>
                    <a href="manage_deductions.php" class="submenu-link<?php if ($current_page == 'manage_deductions.php') echo ' active'; ?>">
                        Setup Deductions
                    </a>
                </li>
                <li>
                    <a href="manage_tax_rates.php" class="submenu-link<?php if ($current_page == 'manage_tax_rates.php') echo ' active'; ?>">
                        Manage Tax Rates
                    </a>
                </li>
                <li>
                    <a href="process_payroll.php" class="submenu-link<?php if ($current_page == 'process_payroll.php') echo ' active'; ?>">
                        Process Payroll
                    </a>
                </li>
                <li>
                    <a href="pay_salaries.php" class="submenu-link<?php if ($current_page == 'pay_salaries.php') echo ' active'; ?>">
                        Pay Salaries
                    </a>
                </li>
                <li>
                    <a href="pay_authorities.php" class="submenu-link<?php if ($current_page == 'pay_authorities.php') echo ' active'; ?>">
                        Pay Authorities
                    </a>
                </li>
                <li>
                    <a href="view_payslips.php" class="submenu-link<?php if ($current_page == 'view_payslips.php') echo ' active'; ?>">
                        View Payslips
                    </a>
                </li>
            </ul>
        </li>

        <!-- Store Management -->
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon"><i class="fas fa-store"></i></span>
                <span class="menu-text">Store Management</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <li>
                    <a href="manage_items.php" class="submenu-link<?php if ($current_page == 'manage_items.php') echo ' active'; ?>">
                        Manage Items
                    </a>
                </li>
                <li>
                    <a href="manage_stock.php" class="submenu-link<?php if ($current_page == 'manage_stock.php') echo ' active'; ?>">
                        Manage Stock
                    </a>
                </li>
                <li>
                    <a href="student_sales.php" class="submenu-link<?php if ($current_page == 'student_sales.php') echo ' active'; ?>">
                        Student Sales
                    </a>
                </li>
            </ul>
        </li>

        <!-- Reports -->
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon"><i class="fas fa-chart-bar"></i></span>
                <span class="menu-text">Reports</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <li>
                    <a href="financial_dashboard.php" class="submenu-link<?php if ($current_page == 'financial_dashboard.php') echo ' active'; ?>">
                        Financial Dashboard
                    </a>
                </li>
                <li>
                    <a href="fee_reports.php" class="submenu-link<?php if ($current_page == 'fee_reports.php') echo ' active'; ?>">
                        Fee Reports
                    </a>
                </li>
                <li>
                    <a href="fees_summary.php" class="submenu-link<?php if ($current_page == 'fees_summary.php') echo ' active'; ?>">
                        Fees Summary
                    </a>
                </li>
                <li>
                    <a href="student_tuition_fee_receivable.php" class="submenu-link<?php if ($current_page == 'student_tuition_fee_receivable.php') echo ' active'; ?>">
                        Student Tuition Fee Receivable
                    </a>
                </li>
                <li>
                    <a href="balance_sheet_report.php" class="submenu-link<?php if ($current_page == 'balance_sheet_report.php') echo ' active'; ?>">
                        Balance Sheet
                    </a>
                </li>
                <li>
                    <a href="profit_loss_report.php" class="submenu-link<?php if ($current_page == 'profit_loss_report.php') echo ' active'; ?>">
                        Profit & Loss
                    </a>
                </li>
                <li>
                    <a href="cash_flow_statement.php" class="submenu-link<?php if ($current_page == 'cash_flow_statement.php') echo ' active'; ?>">
                        Cash Flow Statement
                    </a>
                </li>
                                <li>
                    <a href="cashbook.php" class="submenu-link<?php if ($current_page == 'cashbook.php') echo ' active'; ?>">
                        Cash Book
                    </a>
                </li>
                <li>
                    <a href="budget_vs_actual_report.php" class="submenu-link<?php if ($current_page == 'budget_vs_actual_report.php') echo ' active'; ?>">
                        Budget vs Actual
                    </a>
                </li>
                <li>
                    <a href="store_report.php" class="submenu-link<?php if ($current_page == 'store_report.php') echo ' active'; ?>">
                        Store Revenue Report
                    </a>
                </li>
                <li>
                    <a href="calculate_depreciation.php" class="submenu-link<?php if ($current_page == 'calculate_depreciation.php') echo ' active'; ?>">
                        Calculate Depreciation
                    </a>
                </li>
                <li>
                    <a href="general_ledger.php" class="submenu-link<?php if ($current_page == 'general_ledger.php') echo ' active'; ?>">
                        General Ledger
                    </a>
                </li>
                <li>
                    <a href="trial_balance_report.php" class="submenu-link<?php if ($current_page == 'trial_balance_report.php') echo ' active'; ?>">
                        Trial Balance
                    </a>
                </li>
                <li>
                    <a href="custom_report_builder.php" class="submenu-link<?php if ($current_page == 'custom_report_builder.php') echo ' active'; ?>">
                        Custom Reports
                    </a>
                </li>
                
            </ul>
        </li>

        <!-- Settings -->
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon"><i class="fas fa-cog"></i></span>
                <span class="menu-text">Settings</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <li>
                    <a href="expense_income_categories.php" class="submenu-link<?php if ($current_page == 'expense_income_categories.php') echo ' active'; ?>">
                        Expense & Income Categories
                    </a>
                </li>
                <li>
                    <a href="manage_chart_of_accounts.php" class="submenu-link<?php if ($current_page == 'manage_chart_of_accounts.php') echo ' active'; ?>">
                        Chart of Accounts
                    </a>
                </li>
                <li>
                    <a href="manage_budget_categories.php" class="submenu-link<?php if ($current_page == 'manage_budget_categories.php') echo ' active'; ?>">
                        Budget Categories
                    </a>
                </li>
                <li>
                    <a href="manage_asset_categories.php" class="submenu-link<?php if ($current_page == 'manage_asset_categories.php') echo ' active'; ?>">
                        Asset Categories
                    </a>
                </li>
            </ul>
        </li>

       

        <!-- Audit Trail -->
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon"><i class="fas fa-history"></i></span>
                <span class="menu-text">Audit Trail</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <li>
                    <a href="activity_logs.php" class="submenu-link<?php if ($current_page == 'activity_logs.php') echo ' active'; ?>">
                        Accountant Activity Logs
                    </a>
                </li>
                <li>
                    <a href="view_asset_audit_logs.php" class="submenu-link<?php if ($current_page == 'view_asset_audit_logs.php') echo ' active'; ?>">
                        Asset Audit Logs
                    </a>
                </li>
            </ul>
        </li>

        <!-- Tools -->
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon"><i class="fas fa-tools"></i></span>
                <span class="menu-text">Tools</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <!-- Notifications -->
                <li class="has-submenu">
                    <a href="#" class="submenu-link submenu-toggle">
                        <span class="menu-text">Notifications</span>
                        <span class="submenu-arrow">▸</span>
                    </a>
                    <ul class="submenu">
                        <li>
                            <a href="send_announcement.php" class="submenu-link<?php if ($current_page == 'send_announcement.php') echo ' active'; ?>">
                                Send Announcement
                            </a>
                        </li>
                        <li>
                            <a href="test_notification_system_updated.php" class="submenu-link<?php if ($current_page == 'test_notification_system_updated.php') echo ' active'; ?>">
                                Test Notifications
                            </a>
                        </li>
                    </ul>
                </li>
            </ul>
        </li>

        <!-- Logout -->
        <li class="menu-item logout-item">
            <a href="logout.php" class="menu-link">
                <span class="menu-icon"><i class="fas fa-sign-out-alt"></i></span>
                <span class="menu-text">Logout</span>
            </a>
        </li>
    </ul>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const submenuToggles = document.querySelectorAll('.submenu-toggle');
        const mobileMenuToggle = document.getElementById('mobile-menu-toggle');
        const accountingSidebar = document.querySelector('.accounting-sidebar');

        submenuToggles.forEach(toggle => {
            toggle.addEventListener('click', function(e) {
                e.preventDefault();
                const parentItem = this.closest('.has-submenu');
                parentItem.classList.toggle('open');
            });
        });

        if (mobileMenuToggle && accountingSidebar) {
            mobileMenuToggle.addEventListener('click', function() {
                accountingSidebar.classList.toggle('open');
            });
        }
    });
</script>