<?php
require_once __DIR__ . '/../config.php';

function getUserSubscriptionFeatures() {
    if (!isset($_SESSION['user_id'])) {
        return null;
    }
    global $pdo;
    $user_id = $_SESSION['user_id'];

    // Fetch user's active subscription features
    $stmt = $pdo->prepare("
        SELECT sp.features
        FROM client_subscriptions cs
        JOIN subscription_packages sp ON cs.package_id = sp.id
        WHERE cs.user_id = ? AND cs.subscription_status = 'active'
        LIMIT 1
    ");
    $stmt->execute([$user_id]);
    $subscription = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$subscription) {
        return null;
    }
    $features = json_decode($subscription['features'], true);
    return $features ?: null;
}

function hasFeatureAccess($feature) {
    $features = getUserSubscriptionFeatures();
    if (!$features) {
        return false;
    }
    return !empty($features[$feature]);
}

function requireFeatureAccess($feature, $upgradeMessage = null) {
    if (!hasFeatureAccess($feature)) {
        if (!$upgradeMessage) {
            $upgradeMessage = "This feature is not available in your current subscription. Please <a href='/subs/dashboard.php'>upgrade your package</a> to access it.";
        }
        echo "<div class='upgrade-notice' style='padding: 15px; background: #fff3cd; border: 1px solid #ffc107; color: #856404; border-radius: 5px; margin: 20px 0;'>$upgradeMessage</div>";
        exit;
    }
}

function getUpgradePromptHTML($featureName) {
    return "<div class='upgrade-prompt' style='color: #d9534f; font-weight: bold;'>
                Upgrade required to access <strong>" . htmlspecialchars($featureName) . "</strong>.
                <a href='/subs/dashboard.php'>Click here to upgrade your package</a>.
            </div>";
}
?>
