<?php
require_once 'config.php';

try {
    $stmt = $pdo->prepare('SELECT account_code, account_name, account_type FROM chart_of_accounts WHERE account_code = ?');
    $stmt->execute(['4110']);
    $result = $stmt->fetch();

    if ($result) {
        echo "Account 4110: " . $result['account_name'] . " (" . $result['account_type'] . ")";
    } else {
        echo "Account 4110 not found";
    }

    // Also check for tuition-related accounts
    $stmt = $pdo->prepare('SELECT account_code, account_name, account_type FROM chart_of_accounts WHERE account_name LIKE ?');
    $stmt->execute(['%tuition%']);
    $tuition_accounts = $stmt->fetchAll();

    echo "\n\nTuition-related accounts:\n";
    foreach ($tuition_accounts as $account) {
        echo "- " . $account['account_code'] . ": " . $account['account_name'] . " (" . $account['account_type'] . ")\n";
    }

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>
