<?php
require_once '../config.php';

$message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['add_supplier'])) {
        $supplier_name = trim($_POST['supplier_name']);
        $contact_person = trim($_POST['contact_person']);
        $email = trim($_POST['email']);
        $phone = trim($_POST['phone']);
        $address = trim($_POST['address']);

        if (empty($supplier_name)) {
            $message = 'Supplier name is required.';
        } elseif (!empty($email) && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $message = 'Please enter a valid email address.';
        } else {
            try {
                // Check if supplier name already exists
                $stmt = $pdo->prepare("SELECT id FROM suppliers WHERE name = ?");
                $stmt->execute([$supplier_name]);
                if ($stmt->fetch()) {
                    $message = 'A supplier with this name already exists.';
                } else {
                    $stmt = $pdo->prepare("
                        INSERT INTO suppliers (name, contact_person, email, phone, address, status, created_at)
                        VALUES (?, ?, ?, ?, ?, 'active', NOW())
                    ");
                    $stmt->execute([$supplier_name, $contact_person, $email, $phone, $address]);

                    // Redirect to prevent form resubmission (PRG pattern)
                    header("Location: add_suppliers.php?success=add");
                    exit;
                }
            } catch (PDOException $e) {
                $message = 'Error adding supplier: ' . $e->getMessage();
            }
        }
    }
}

// Handle success messages from redirect
if (isset($_GET['success'])) {
    switch ($_GET['success']) {
        case 'add':
            $message = 'Supplier added successfully!';
            break;
    }
}

include 'includes/accounting_header.php';
?>

<?php if ($message): ?>
    <div class="message <?php echo strpos($message, 'Error') === 0 || strpos($message, 'already exists') !== false ? 'error' : 'success'; ?>">
        <?php echo htmlspecialchars($message); ?>
    </div>
<?php endif; ?>

<div class="form-container">
    <h2>Add New Supplier</h2>
    <form method="post" action="add_suppliers.php" class="supplier-form">
        <div class="form-group">
            <label for="supplier_name">Supplier Name *</label>
            <input type="text" id="supplier_name" name="supplier_name" required placeholder="e.g., ABC Supplies Ltd">
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="contact_person">Contact Person</label>
                <input type="text" id="contact_person" name="contact_person" placeholder="e.g., John Doe">
            </div>

            <div class="form-group">
                <label for="email">Email</label>
                <input type="email" id="email" name="email" placeholder="supplier@example.com">
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="phone">Phone</label>
                <input type="text" id="phone" name="phone" placeholder="+233 XX XXX XXXX">
            </div>

            <div class="form-group">
                <label for="address">Address</label>
                <input type="text" id="address" name="address" placeholder="Supplier address">
            </div>
        </div>

        <div class="form-actions">
            <button type="submit" name="add_supplier" class="btn btn-primary">Add Supplier</button>
            <a href="manage_suppliers.php" class="btn btn-secondary">View All Suppliers</a>
        </div>
    </form>
</div>

<style>
.form-container {
    background: #f8f9fa;
    padding: 30px;
    border-radius: 8px;
    margin-bottom: 30px;
    border: 1px solid #e9ecef;
    max-width: 800px;
    margin: 0 auto;
}

.supplier-form {
    max-width: 100%;
}

.form-group {
    margin-bottom: 20px;
}

.form-group label {
    display: block;
    margin-bottom: 5px;
    font-weight: 600;
    color: #495057;
}

.form-group input[type="text"],
.form-group input[type="email"] {
    width: 100%;
    padding: 10px;
    border: 1px solid #ced4da;
    border-radius: 4px;
    font-size: 14px;
}

.form-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 20px;
}

.form-actions {
    display: flex;
    gap: 10px;
    justify-content: center;
    margin-top: 30px;
}

.message {
    padding: 12px 16px;
    margin-bottom: 20px;
    border-radius: 4px;
    text-align: center;
}

.message.success {
    background-color: #d4edda;
    color: #155724;
    border: 1px solid #c3e6cb;
}

.message.error {
    background-color: #f8d7da;
    color: #721c24;
    border: 1px solid #f5c6cb;
}

.btn {
    padding: 12px 24px;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    font-size: 14px;
    font-weight: 500;
    text-decoration: none;
    display: inline-block;
    transition: all 0.3s ease;
    text-align: center;
}

.btn-primary {
    background: linear-gradient(135deg, #2E7D32 0%, #4CAF50 100%);
    color: #fff;
}

.btn-primary:hover {
    background: linear-gradient(135deg, #4CAF50 0%, #2E7D32 100%);
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.2);
}

.btn-secondary {
    background: linear-gradient(135deg, #6c757d 0%, #5a6268 100%);
    color: #fff;
}

.btn-secondary:hover {
    background: linear-gradient(135deg, #5a6268 0%, #6c757d 100%);
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.2);
}

@media (max-width: 768px) {
    .form-row {
        grid-template-columns: 1fr;
    }

    .form-actions {
        flex-direction: column;
    }
}
</style>

<?php
include '../includes/admin_footer.php';
?>
