<?php
require_once '../config.php';

echo "<h1>Add Missing Accounting Accounts</h1>";
echo "<p>Adding accounts required by the fee assignment system...</p>";

try {
    $pdo->beginTransaction();

    // Accounts needed by assign_fees.php
    $missing_accounts = [
        [
            'account_code' => '1121',
            'account_name' => 'Student Fees Receivable',
            'account_type' => 'Asset',
            'normal_balance' => 'debit',
            'description' => 'Money owed by students for assigned fees',
            'is_system_account' => TRUE
        ],
        [
            'account_code' => '4110',
            'account_name' => 'Tuition Fees',
            'account_type' => 'Revenue',
            'normal_balance' => 'credit',
            'description' => 'Revenue from tuition and school fees',
            'is_system_account' => TRUE
        ]
    ];

    $added_count = 0;
    foreach ($missing_accounts as $account) {
        // Check if account already exists
        $stmt = $pdo->prepare("SELECT id FROM chart_of_accounts WHERE account_code = ?");
        $stmt->execute([$account['account_code']]);
        $existing = $stmt->fetch();

        if (!$existing) {
            $stmt = $pdo->prepare("
                INSERT INTO chart_of_accounts
                (account_code, account_name, account_type, normal_balance, description, is_system_account, current_balance)
                VALUES (?, ?, ?, ?, ?, ?, 0.00)
            ");
            $stmt->execute([
                $account['account_code'],
                $account['account_name'],
                $account['account_type'],
                $account['normal_balance'],
                $account['description'],
                $account['is_system_account']
            ]);
            echo "<p style='color: green;'>✅ Added: {$account['account_code']} - {$account['account_name']}</p>";
            $added_count++;
        } else {
            echo "<p style='color: blue;'>ℹ️ Already exists: {$account['account_code']} - {$account['account_name']}</p>";
        }
    }

    $pdo->commit();

    echo "<div style='background: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
    echo "<h2>✅ SUCCESS!</h2>";
    echo "<p>Added $added_count missing accounts to the chart of accounts.</p>";
    echo "<p>The fee assignment system should now work properly.</p>";
    echo "</div>";

} catch (PDOException $e) {
    $pdo->rollBack();
    echo "<div style='background: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
    echo "<h2>❌ ERROR!</h2>";
    echo "<p>Failed to add missing accounts: " . $e->getMessage() . "</p>";
    echo "</div>";
}
?>
